# Review Digital Entrepreneurship and its Role in Innovation Systems: A Systematic Literature Review as a Basis for Future Research Avenues for Sustainable Transitions

Liliya Satalkina $^ { 1 , * \oplus }$ and Gerald Steiner $^ { 1 , 2 , * \oplus }$

1 Department for Knowledge and Communication Management, Danube University Krems, 3500 Krems, Austria   
2 Complexity Science Hub Vienna, 1080 Vienna, Austria   
￥ Correspondence: liliya.satalkina@donau-uni.ac.at (L.S.); gerald.steiner@donau-uni.ac.at (G.S.)

Received: 24 February 2020; Accepted: 29 March 2020; Published: 1 April 2020

Abstract: Digital entrepreneurship is an essential driver within the innovation system. It changes the structure, aims, and networking mechanisms of the overall business system and, ultimately, affects the various levels and dimensions of the innovation system. Bringing inevitable changes to the innovation system, digital technologies may not only provide new business opportunities but also be disruptive and cause new vulnerabilities. In order to gain a rigorous understanding of the hybrid concept of digital entrepreneurship and its role within the transformation of the innovation system, we conducted a systematic literature review. The results of 52 core papers allow for the identification of key categories of digital entrepreneurship and also its differentiation from other types of business activities. The analysis leads to the distinction of the determinants of digital entrepreneurship within three core dimensions of the innovation system, which encompass the entrepreneur (including, e.g., behavioral, competence. and mentality patterns, as well as personal outcomes and consequences of entrepreneurial activity), the entrepreneurial process (including activities that concern digitalization in organizational management processes, transformations within strategic and operational activities, and digital start-up establishment), and its relevant ecosystem (which encompasses, among others, the influence that external infrastructure and institutions have on digital entrepreneurship development). The systematization of the existing literature is highly relevant for future research that aims to understand the interrelations between the transformation of entrepreneurial structures within innovation systems as well as the socioeconomic system in general. Such understanding requires further extended research in fields related to method, content, and theory.

Keywords: digital entrepreneurship; innovation system; PRISMA; digital transformation; sustainable transition

# 1. Introduction

In the last century, the economic performance and innovation success of countries has increasingly depended on digital technology developments [1]. Digitalization is broadly associated with the changes that relate to big data analytics, the adoption of digital technologies, and an increase in their utilization [2–4]. Research shows that the rates of digitalization continue to grow. According to the Digital Economy and Society Index (see Appendix A), the level of digital performance of EU countries increased to $5 2 . 4 5 \%$ in 2019 compared to $4 4 . 3 5 \%$ and $3 9 . 0 5 \%$ in 2016 and 2014, respectively (see https://digital-agenda-data.eu/). Compared to digitization, which refers to the digital conversion of information, digitalization concerns the broad implications of such processes and their subsequent effects on various contexts of the socioeconomic system [5]. Therefore, digitalization may also be considered one of the coupling mechanisms between different dimensions of the socioeconomic system (technological, social, economic, and ecological). For this reason, digitalization represents a source of new challenges to the resilience of socioeconomic systems; on the one hand, it comes with opportunities, but on the other, it also brings new risks and unforeseen consequences [6,7]. Therefore, it becomes important to deal with such challenges in a sustainable and future oriented manner (corresponding also to the principles of the Sustainable Development Goals).

Although digitalization concerns all spheres of social life [2], it primarily determines the transformation of entrepreneurial and business models in different industries. The main reason for this is the changing needs of society (either caused by new demands or pushed by industry) regarding products and services (e.g., enhanced connectivity and individualization) that determine adaptations in the value-creation process as well as communication and cooperation patterns; this process, in turn, fosters innovative transformations of business models [8–10].

By challenging and restructuring business patterns in all industrial sectors, digitalization becomes, on the one hand, an outcome and, on the other hand, a source for innovation, while entrepreneurs and intrapreneurs may be not only the drivers but also the affected agents of digital transformations. Innovations and, consequently, the innovation system may be considered a metasystem in which entrepreneurial activities become the driving force for the utilization of digital opportunities (see the section titled Innovation System Conception). Hence, digital entrepreneurship—as a process and as an outcome—is a mechanism within the innovation system that is related to the formation of new ventures or the transformation of existing businesses [11], with novel ways of value creation [12,13], that becomes a driving force for innovation development [8,14,15].

The crucial role of digitalization as a driver of transformation within innovation systems is evidenced both by scientific research (e.g., [9,14,15]) and policy-related surveys of the European Commission, which show that $9 6 \%$ of business leaders consider digital technologies to be critical for innovative development and continuous, qualitative economic growth [16]. Therefore, considering digital entrepreneurship within the innovation system is crucial for understanding its potential impacts on transformations and sustainable transitions of such systems. In that case, we do not focus on entrepreneurial ecosystems individually. Instead, we consider them within the dimensions of the innovation system.

Digital technologies may not only result in business opportunities; they may also, simultaneously, be disruptive and cause new vulnerability spaces [17,18]. This is particularly true since, within the reframing of business models, digital technologies have an impact on the various levels of the innovation system (see the Innovation System Conception section), reshaping industry competition and networking patterns within this system [14]. Furthermore, the integration of digitalization in business processes implicates not only internal changes related to new organizational management strategies and entrepreneurial processes. External system conditions (e.g., institutional influence, new market tendencies, changes in competitive advantages) as well as social attitudes (e.g., digital trust, technology adoption) also have a significant effect. An analysis of the framework conditions for digital entrepreneurship in 28 EU countries in 2018 showed Denmark, Sweden, Luxembourg, and Finland as leaders, with an average rate of 75.7 on the European Index of Digital Entrepreneurship Systems (EIDES) (see Appendix A). Comparatively, the average rate of the EIDES for the country followers (e.g., Germany, Austria, France) was 52.3 [19]. Therefore, it is crucial to understand the whole mechanism of digital entrepreneurship with respect to its role within the innovation system, particularly its transformations and sustainable transitions. This includes, among others, changes in the communication and interaction patterns of involved innovation agents, opportunity assessment, and resource considerations as part of a comprehensive and sustainable innovation process. Consequently, the aim of the research was to (1) derive a clear understanding of how digital entrepreneurship efforts are embedded within the innovation system and coupled with its relevant subsystems; and (2) determine future avenues for contributing sustainability implications of entrepreneurship and innovation research.

In order to gain a deeper understanding of these interrelated systems, we applied a comprehensive systematic literature review based on the Preferred Reporting Items for Systematic Reviews and Meta-Analyses approach (PRISMA) for analyzing existing approaches to digital entrepreneurship conceptions and for a better understanding of these conceptions’ interrelatedness with the innovation system. The following research questions were posed:

(1) What are the key categories that define digital entrepreneurship and its role within the innovation system, particularly differentiating it from other types of entrepreneurship? (2) How are digital initiatives implemented within entrepreneurship processes (either transforming existing processes or establishing new ones), particularly with respect to involved agents, opportunities and risks, resources, processes, and other factors?

To clarify the research questions, we defined the key determinants of digital entrepreneurship and analyzed their interconnections and links with the innovation system. The article is organized as follows. In the section Innovation System Conception, we explain the validity of the innovation system approach for understanding digital entrepreneurship as a specific challenge and its impacts on transformation processes. Based on the generalization of existing theories and approaches, we provide the structure of the innovation system. The Research Design section describes the working process and research design that was applied for the systematic literature review. In the section titled Approach to the Review: PRISMA Method, we provide a detailed description of the PRISMA method and explain how it was implemented in our research (including search terms, selection criteria, and exclusion criteria). The Results of Systematic Literature Review section contains the overview of basic study characteristics and an overview of categories in digital entrepreneurship, defined within a systematic literature review. In the Discussion of the Results section, we analyze the defined categories and generalize them according to the determinants of digital entrepreneurship. In the section Future Research Directions for Sustainable Implications, we suggest avenues for method-, content-, and theory-related extensions in analyzing the impacts of digitalization on sustainable societal transitions.

# 2. Innovation System Conception

In our research, the innovation system is considered as a metasystem that provides the conditions for entrepreneurial activities and further innovation performance (within both opportunities and limitations). This understanding is evidenced by studies in the field that relate an innovation system primarily to a network of elements that enables the generation and distribution of knowledge that enhances innovation performance (e.g., [20–25]).

Dealing with societal challenges and enhancing a system’s resilience, an innovation system may be understood as an interactive learning system with a focus on the enhanced learning capability of individuals, organizations, and regions as part of capacity building in order to meet new challenges and to enable an innovation-based economic performance [22,26]. An innovation system is formed not only on a macrolevel (as a network of institutions) but also on a microlevel (as an internal organization of the company with the system of internal relations) [27] and is characterized by hierarchical and structural dimensions. The hierarchical dimensions include the levels from the individual to the organizational, regional, national, subcontinental, continental, and global. Such divisions are also overlapped by sectoral and regional dimensions (e.g., urban, rural, metaregions). Within the structural dimensions, the innovation system may be defined by the following dimensions: (1) political, legal, and institutional; (2) sociocultural; (3) economic and financial; (4) technological; (5) ecological; and (6) infrastructural (physical and virtual space) dimensions. Figure 1 shows the structure of the innovation system.

![](images/38b6cc671d50c69f8ca3308f4e46ff2354077bf2dca847cdfff2bfe19d56f74e.jpg)  
igure 1. Figure 1.Structure of the innovation system [28,29]. Structure of the innovation system [28,29].

The conception of an innovation system is related to the core principles of various theories. Particularly, the innovation system theory [21,22,26,30,31] describes the adaptive learning capabilities of innovation systems. The understanding of vulnerabilities (opportunities and risks) within the innovation system is very much based on the coupled human–environment system theory [32]. The transition of innovation systems within the time frames and their development and resilience, in addition to their impact on societal sustainability, is discussed within the panarchy [33], creative destruction [24], disruptive innovation [34], and transition theories [35–41].

An early explanation of innovation in light of the interdependency of different factors that define the structure of the innovation system goes back to Joseph Schumpeter. He identified the crucial role of entrepreneurship and entrepreneurial leadership for the distribution and use of knowledge, ultimately leading to innovation [24]. Furthermore, according to Schumpeter (1934, 1942), innovation is considered a “new combination” of factors that determines “creative destruction” and relates to five core spheres, namely products, methods of production, markets, sources of raw materials, and industry structure [24,42]. The key role of entrepreneurs lies in undertaking Schumpeter’s “new factor combinations,” commercializing ideas and inventions, and creating new opportunities for investments and employment, enhancing, ultimately, economic competitiveness and change [24,42–46]. However, entrepreneurs’ contributions to knowledge formation and dissemination depend on their economic and technical competences and their knowledge, as well as their perception of the environment and opportunities [20,47]. In addition, another important determinant is the incentive for innovation, particularly the motivation for designing or following the innovative environment [48,49]. Schumpeter also identified important effects of non-economic factors within the innovation system, such as personal motivation and cultural and historical factors [43].

The implication of the innovation system approach for understanding digital entrepreneurship is based on the idea that digitalization, with its risks and opportunities, may be considered one of a number of societal challenges. The latter are complex in nature and cannot be seen in isolation but rather have implications ranging from a global scale to the company level and to each individual [50,51]. Therefore, to be understood and successfully managed, digital entrepreneurship requires a comprehensive innovation system approach that helps us to better understand the various effects of digitalization with respect to different stakeholders and dimensions of the system (see Figure 1).

By defining knowledge as a key element in an innovation system, researchers distinguish two approaches to the role of different institutions. The “narrow approach” considers, primarily, the impact of institutions on the acquisition, distribution, and use of knowledge [22], while the “broad approach” includes the effects of political, cultural, and economic factors and policies on institutions, their interaction, and further innovative performance [21].

An analysis of the statements above allows us to suggest that the innovation system may be defined as a system that couples a broad range of elements and their interactions on different levels (from internal management processes to institutional networks) that, under the effects of political, cultural, and other factors, form the conditions for knowledge creation and dissemination as well as further innovative performance. Strong driving forces of innovation systems are the entrepreneurial activities and initiatives that may lead, however, to “creative destruction.”

# 3. Research Design

A systematic literature review is an essential tool for summarizing available information accurately and reliably, sorting empirical proofs that fit prespecified eligibility criteria, and answering specific research questions. Compared to other methods of literature analysis, a systematic review is based on explicit, systematic methods that enhance the reliability of the findings and minimize bias. It includes the following steps [52]: (1) the development of a clearly stated set of objectives; (2) a systematic search that attempts to identify all studies that meet the eligibility criteria; (3) an assessment of the validity of the findings in the included studies; and (4) a systematic presentation and synthesis of the characteristics and findings of the included studies. The overall research design consisted of two core steps: (1) we conducted a systematic literature review applying the PRISMA method, extracting theSustainability 2020, 12, x FOR PEER REVIEW 6 of 27 core categories of digital entrepreneurship, and grouping them into the nodes; and (2) we analyzed and discussed the initial nodes and defined the determinants of digital entrepreneurship (Figure 2).

![](images/8450043760b83c764914f8ddff7ac8acb8bfba96eebfc275b6300f33e5422223.jpg)  
Figure 2. Working process and research design (own study). Dashed lines represent the results Figure 2. Working process and research design (own study). Dashed lines represent the results achieved achieved at each stage of the wat each stage of the work process.

# 59 4. Approach to the Review: PRISMA Method4. Approach to the Review: PRISMA Method

In our research, the systematic literature review was conducted according to the Preferred In our research, the systematic literature review was conducted according to the Preferred Reporting Items for Systematic Reviews and Meta-Analyses approach (PRISMA), which includes a 63 by an international group of scientists in 1999 and was called the QUOROM Statement (quality of 27-item checklist and a four-phase flow diagram. The basic framework for PRISMA was developed 64 reporting of meta-analysis). The working group comprised 30 members, mostly representatives of by an international group of scientists in 1999 and was called the QUOROM Statement (quality of 65 epidemiological and clinical fields [53]. The core aim was to improve reporting within meta-analyses, reporting of meta-analysis). The working group comprised 30 members, mostly representatives of 66 particularly in healthcare evaluations [52]. In 2005, the method was revised and extended with a new epidemiological and clinical fields [53]. The core aim was to improve reporting within meta-analyses, 67 27-item checklist, including the four-phase PRISMA flow diagram [52]. Although the initial aim of particularly in healthcare evaluations [52]. In 2005, the method was revised and extended with a new the revised method was to increase transparency in clinical research, the method is also currently 27-item checklist, including the four-phase PRISMA flow diagram [52]. Although the initial aim of the 70 revised method was to increase transparency in clinical research, the method is also currently applied 71 transparent and well-structured report framework. Original literature focusing on PRISMA (e.g., in systematic literature reviews in other fields (e.g., [54,55]). The core peculiarity of the method is 72 [52,56,57]) is widely available at http://www.prisma-statement.org/. that, without addressing the review process in a detailed manner, PRISMA provides a transparent and well-structured report framework. Original literature focusing on PRISMA (e.g., [52,56,57]) is widely 73 4.1. Search Terms and Selection Criteria available at http://www.prisma-statement.org/.

# 75 well-established citation databases4.1. Search Terms and Selection Criteria

the choice enabled us to cover the massive number of existing publications on a relevant topic. We conducted the search using two databases: Harvard Hollis and Web of Knowledge. Both are 78 well-established citation databases of peer-reviewed literature in the field of social sciences. Hence, the 79 abstracts; (3) a full-text assessment; and (4) decision-making concerning eligibility (see Figure 3). choice enabled us to cover the massive number of existing publications on a relevant topic. According to the PRISMA method, the selection process was performed in four steps: (1) the identification of relevant research by briefly searching through the databases; (2) a screening of abstracts; (3) a full-text assessment; and (4) decision-making concerning eligibility (see Figure 3).

The search actions through each database were conducted with the following keyword combinations: “digital entrepreneurship” and “digital business.” We specified the search algorithm by the “type of document,” “time period,” and “language” criteria. Consequently, only peer-reviewed articles published in journals from 2014 to 2018 in the English language were included in the review. The selection of this period was determined by the emerging interests in the topic of digitalization and socio-digital transformations in recent years. Accordingly, a five-year period (from 2014 to 2018) allowed us to cover the broad range of existing research in this field. The first brief search of the databases identified 796 records. After duplicates were removed, 740 articles remained for further screening. The data sheet was formed with the following information about the articles: title, author name, year of publication, and abstract. For these articles, the next round, screening by abstracts, was conducted.

![](images/dbf73a0da796b60103d2cf63cfb4f983018e9e4e345f6cd88b974fc203ebbf27.jpg)  
Figure 3. PRISMA flowchart (authors’ results based on the PRISMA Flowchart template). Figure 3. PRISMA flowchart (authors’ results based on the PRISMA Flowchart template).

The search actions through each database were conducted with the following keyword The overall inclusion criteria for the articles were developed based on the conceptual outline of digital entrepreneurship and innovation systems provided in the previous sections. Because of the stated research questions and in order to fulfill the inclusion criteria, the studies had to provide the review. The selection of this period was determined by the emerging interests in the topic of an understanding of digital entrepreneurship as a form of organization management not just on digitalization and socio-digital transformations in recent years. Accordingly, a five-year period (from a small-agent level. The research had to focus on the interconnection of digital entrepreneurship 2014 to 2018) allowed us to cover the broad range of existing research in this field. The first brief mechanisms with the main elements of the innovation system such as involved agents, opportunities search of the databases identified 796 records. and risks, resources, processes, and factors.

r further screening. The data sheet was formed with the following information about the articles: Therefore, at the stage of screening the abstracts, the reasons for excluding the articles were as follows: (1) a narrow specialization and an orientation on only certain business fields or industry The overall inclusion criteria for the articles were developed based on the conceptual outline of types; (2) a focus on certain products of digitalization (e.g., a specific software package); (3) the digital entrepreneurship and innovation systems provided in the previous sections. Because of the orientation of the research on a specific case, market, or region; (4) a focus on the technical properties stated research questions and in order to fulfill the inclusion criteria, the studies had to provide an of digitalization; and (5) the absence of a relationship with interdisciplinarity and a singular focus on a understanding of digital entrepreneurship as a form of organization management not just on a small-certain discipline (e.g., medicine, engineering). After the abstract screening, 121 articles were selected agent level. The research had to focus on the interconnection of digital entrepreneurship mechanisms for full-text analysis. We accessed 111 articles through the databases, and we requested 10 directly with the main elements of the innovation system such as involved agents, opportunities and risks, from corresponding authors since there was no access to these articles either through databases or library services. Finally, two articles were provided by authors, and eight articles were excluded due follows: (1) a narrow specialization and an orientation on only certain business fieto access reasons. A total of 113 articles were accessed for full-text screening.

pes; (2) a focus on certain products of digitalization (e.g., a specific software package); (3) the We created a spreadsheet and coded the included articles with the following data: title, names orientation of the research on a specific case, market, or region; (4) a focus on the technical properties of the authors, year of publication, concepts analyzed, country of authors’ affiliation, and country of analysis (if determined).

# 4.2. Exclusion Criteria

Given the stated inclusion criteria, during the full-text screening, some articles were excluded for the following reasons:

1 Reference to entrepreneurship: Referring to digital entrepreneurship, some of the research focused on the overall macro-economic scope of digitalization or referred to such generalized concepts as: (1) a digital industrial policy; (2) the phenomenon of digital innovation and transformation; (3) the phenomenon of innovation performance; (4) consumption within the digital economy, etc. The aim of the present study was to analyze the digital transformations within organization management.

2 Sphere of analysis: The core parts of several publications were devoted to particular cases: (1) companies (e.g., Duobus) or company types (e.g., digital platform providers); (2) special markets or industry branches (e.g., health, hardware, gaming, film, and visual products); (3) regional context (e.g., the Zhongguancun ecosystem; Cameroonian or Pakistani cases).

3 Specific focus: This category consisted of those articles that aimed to understand: (1) particular business models that were developed for certain company types (e.g., Product-Service System Business Models); (2) specific characteristics of digital businesses, certain types of activities, or tools within digital entrepreneurship (e.g., Internet market; peer-to-peer platforms; digital artifacts and venture creation; IT department development); (3) specific processes within digitalization (e.g., digital inclusion; learning processes; educational level of entrepreneur; social media applications) and specific implementations of digitalization (e.g., cloud computing; e-commerce activities; e-business); and (4) digital impacts on particular social problems (e.g., women’s issues, ethnic minority problems).

4 Conception: Primarily aiming to provide theoretical input to managerial research, we excluded articles in which (1) digital entrepreneurship was considered only as an example in the overall context, or (2) digitalization was a secondary focus for understanding a certain phenomenon or tendency (e.g., marketing tendencies in terms of digitalization processes).

Following the full-text access, 16 articles were excluded for other reasons. Three articles were excluded based on the “language” criterion (one Polish, one Persian, and one Serbian article); although we stated the restriction on language within the search terms, these articles were identified by databases since they contained English abstracts. An additional 13 articles were excluded according to the “type of document” criterion as they did not relate to peer-reviewed articles. These documents were identified through search engines since they were cited in peer-reviewed editions (two working papers; one book chapter; 10 conference papers). For all the reasons stated, 61 articles were excluded, and 52 articles were included in the qualitative research.

# 5. Results of Systematic Literature Review

# 5.1. An Overview of the Study’s Basic Characteristics

All 52 papers included in the qualitative research were clustered according to year of publication, country of authors’ affiliation, and country of analysis (if specified) (see Appendix B). Most of the included articles (27) were published in 2018; the numbers of publications in 2016 and 2015 were considerably smaller, five and three articles, respectively. No articles published in 2014 were included in the qualitative synthesis. During the screening, we also identified those countries to which researchers had an affiliation or that were objects of case studies and more-detailed analyses. Although at the previous stage we excluded a number of articles with a too-narrow regional context, several articles were still included in the qualitative research. The reason was that the conceptual basis of these articles fulfilled the inclusion criteria (see the section titled Search Terms and Selection Criteria). Overall, 26 countries were identified. Among them, the US and the UK were most often the countries of affiliation (14 and 10 articles, respectively), while China was most often chosen for case studies and research.

We did not apply any initial restrictions to the citation index of the journals in which the articles were published. Nevertheless, after the inclusion in the qualitative synthesis, we also conducted a brief screening of the journals’ rankings (see Appendix C).

# 5.2. Overview of Categories in Digital Entrepreneurship

The qualitative synthesis allowed us to identify which categories researchers refer to most frequently in terms of digital entrepreneurship, given the complex pattern of its development and implementation. For the coding process, the obtained categories were grouped within the initial nodes. Further analysis of the initial nodes obtained during the review process allowed us to distinguish between their relevance according to different scopes within specific dimensions of the innovation system. We classified and grouped the initial nodes into three dimensions. The first dimension relates to behavioral, competence, and mentality patterns, as well as personal outcomes and consequences of entrepreneurial activity. The second dimension refers to activities related to digitalization in the organizational management process, transformations within strategic and operational activities, digital start-up establishment, etc. The third dimension relates to the influence that external infrastructure and institutions have on digital entrepreneurship development. Given these distinct dimensions, we suggest that, within the hierarchical structure of the innovation system, digital entrepreneurship relates to three core scopes, labeled here for conciseness: Entrepreneur, Entrepreneurial Process, and Ecosystem. The generalized results of the systematic literature review are represented in Table 1.

Table 1. Results of the systematic literature review.   

<html><body><table><tr><td>Initial Nodes</td><td>Categories Mentioned</td><td>Literature Sources</td></tr><tr><td colspan="2">I. Entrepreneur</td><td></td></tr><tr><td> Social impact</td><td>Social positioning; Inequality; Emancipatory potential; Ethnic minority entrepreneurship; Digital exclusion; Digital engagement.</td><td>[58-61]</td></tr><tr><td>Digital behavior patterns</td><td>Digital behavior; Identification of business opportunities; Digital entrepreneurial intentions; Entrepreneurial perception; Decision-making process.</td><td>[62-65]</td></tr><tr><td>Knowledge</td><td>Knowle</td><td>[66]</td></tr><tr><td>II. Entrepreneurial Process</td><td></td><td></td></tr><tr><td>Digital business models</td><td>Sustainable business models; Digital transformations; Business convergence; Digital business viability; Risks in models; Types of digitalization.</td><td>[64,67-83]</td></tr><tr><td>Digital determinants</td><td>Factors of success; Digital capabilities; Strategic knowledge and learning; Social media and big data; Digital artifacts; Digital platforms;Digital users; Internet adoption.</td><td>[66,75,77,81]</td></tr><tr><td>Dita and inovative</td><td></td><td>[84-86]</td></tr><tr><td> Start-ups</td><td></td><td>[87-92]</td></tr><tr><td>Value</td><td>Value creation; Revenue mechnism; Cost saving; Resource</td><td>[80,93-97]</td></tr><tr><td>Marketing</td><td>Digital marketing.</td><td>[58,69,98]</td></tr><tr><td colspan="2">III. Ecosystem</td><td></td></tr><tr><td>Facilitating conditions for digital entrepreneurship</td><td>Cities facilitating digital entrepreneurship; Living labs for promoting digital entrepreneurship; Regional digital strategy; Business incubation facilities; Information, technology and institutional support.</td><td></td></tr><tr><td>Processes within the ecosystem</td><td>Competition; Transformation of value categories; Digital infrastructure; Digital users; Spatial, temporal,and spillover factors; Resource and module networks; Institutional barriers and sociocultural restrictions within digital entrepreneurship; Dimensions of digital context; Regional ICT access.</td><td>[60,96,99-109]</td></tr><tr><td>Social networks</td><td>A partnership between different stakeholders; Social capital through social networks.</td><td></td></tr></table></body></html>

# 6. Discussion of the Results

# 6.1. Entrepreneur

An analysis of the initial nodes suggests that the dimension Entrepreneur relates primarily to the digital behavior patterns, social impact, and knowledge nodes. The variety of categories covers the range from digital entrepreneurial intentions to start a business [63] and the related decision-making process [62,64] to knowledge integration [66] and social outcomes for entrepreneurs [58–61].

As basic drivers of the innovation system, entrepreneurs are influenced by digital transformations, particularly in their behavior related to the adoption of digital stimuli and the evaluation of success opportunities [29,74]. Entrepreneurs’ personal attitudes are the initial drivers for entrepreneurial intentions and further decision-making processes [61,62] during the determination of a company’s aims, the identification of business opportunities, the evaluation of risks, and the formation of relevant business strategies [82]. Often, digital entrepreneurial perceptions are the consequence of existing attitudes toward entrepreneurship, subjective norms, and perceived behavioral control [61,62,65] as well as external pressures and the internal digital maturity of the company [65]. Digital entrepreneurial perception is also strongly influenced by trust, which, although currently mentioned only infrequently in scientific articles, is considered in interdisciplinary research initiatives (e.g., the Digital Planet report, presented by The Fletcher School at Tufts University) [110].

Entrepreneurial knowledge is a significant determinant in shaping the motivational process within digital and business engagement, together with career intentions and new venture creation [63]. In particular, digital competences become key determinants of digital entrepreneurship [72,104]. On the one hand, digital competences should be characterized as prerequisites for digital engagement since they define the possibility to be involved and remain competitive in the field. On the other hand, some researchers suppose that digital competences develop due to the digital transformation and “context” influence [104] and also knowledge integration and orchestration [58,66]. In other words, context dimensions affect the extent to which entrepreneurs may utilize their digital competences [104]. The effect of context is often reflected in the broadening of social networks that develop structural connections between individuals [105] and foster regional information and communications technology (ICT) access and entrepreneurship performance, also becoming a facilitator in the conditions of resource constraints and institutional barriers [108] (see also the Ecosystem dimension).

The process of knowledge acquisition is a prerequisite for learning orchestration and cognition, influenced not only by personal and behavioral factors but also by “environmental” factors [99]. Knowledge mobilization and knowledge coordination, in particular, are strongly affected by the diversity of the social network, the individual nodal position within it, and the “structural holes” effect [66]. Managers’ knowledge and motivation patterns determine how the key elements of a business model, such as production, commercialization and distribution, customer management, transaction mechanisms, partner and transaction management, labor policies, value creation, internal organizational management, etc., are transformed due to digital effects [74].

Given the new opportunities and risks associated with digital transformations, managers face dilemmas related to the availability and distribution of resources for the development of the information technologies (IT), privacy and security points, employee and customer policies, and ethics [64]. This also provides evidence for the “hybrid” and dual effect of digitalization, particularly in entrepreneurship, relating it to disruptive processes and vulnerability spaces. Dellermann et al. (2017) proposed a framework of strategic risk management in digital business model innovation that includes different categories of risks, dividing them into internal risks and risks from the external environment, or relational and performance risks [68]. Thus, a business strategy may be based on a business-, customer-, organizational-, and/or technology-centric orientation [84].

Within the sphere of personal outcomes, digital entrepreneurship may help overcome the problems of social positioning and sociocultural restrictions by transforming family relations [59,60], by involving women entrepreneurs [59], and by providing more opportunities for entrepreneurial activities within ethnic minorities [58]. However, digitalization may become a source of new inequalities [61], determining inclusion or exclusion to entrepreneurial activity due, in particular, to social, cultural, and institutional gaps [60] or resource restrictions [58].

The analysis of the initial nodes extracted from the literature sources (see Table 1) and suggestions about their interrelational patterns allow us to conclude that the scope of Entrepreneur is characterized by personal attitudes, competences, decision-making processes, knowledge, and personal outcomes [58–64,66,82,104]. Extending the obtained results with our own reflections, we may posit that the first three determinants of digital entrepreneurship are the following:

1. Personal characteristics and competences: basic characteristics related to starting a digital business   
(e.g., gender, age, education, entrepreneurial knowledge, the entrepreneur’s knowledge about the   
business environment); professional flexibility (e.g., ability to gain new competences, readiness for   
continuous education); 2. Decision-making and bounded rationality: opportunity–risk attitude (e.g., success evaluation,   
business orientation and strategy, perception of business opportunities); personal motivation (e.g.,   
entrepreneurship intentions); and 3. Personal outcomes: social positioning (e.g., transformation of existing social linkages and   
positions, new facets in cultural norms and traditions, transformations within family relations); access   
to new entrepreneurial possibilities (e.g., digital inclusion, development of new social inequalities).

# 6.2. Entrepreneurial Process

The Entrepreneurial Process connects initial nodes such as:

Digital business models [64,67–74,76–80,82,83]; . Digital determinants [66,75,77,81]; . Digital and innovative orientation [84–86]; Start-ups [87–92]; • Value [80,93–97]; and . Marketing [58,69,98].

Within organizational management, digital transformation covers all levels from strategic to operational [64], as well as all its layers (resource, activity, and actor) [76]. Strongly interrelated with digital competences and based on the digital strategy of organization [94,97], digital transformation is a rather inevitable process that, on the one hand, may be considered to be a reactive step and, on the other hand, a voluntary entrepreneurial process [71].

Digital technologies change business architecture through the transformation of business models. More specifically, the implementation of digital artifacts and the utilization of digital platforms, as well as other technical affordances, foster the formation of business model innovations that differ from traditional business frameworks along the entire value chain from production to commercialization [72]. These mechanisms are reflected in the convergence of digital business [79], as well as reprogrammability, recombinability, and generativity properties that allow the involvement of different digital artifacts and devices, separate the functional aspects and physical embodiment of the device, and provide further recombinations of elements for the development of further functionality of the device [73].

The ability of a company to participate in a digital transformation often depends on several prerequisites for business digitalization, such as digital orientation (within market and entrepreneurial orientations) [86], digital capabilities [69], and, particularly, managerial strategies based on an understanding of digital processes [80]. However, digital transformations depend on more than managerial actions and strategies. Schallmo et al. (2017) applied several categories in their work that outlined the preconditions for the development and implementation of a digital business model and combined them in a transformation roadmap. Several researchers consider, in addition, IT capability [75] and internal IT infrastructure maturity [65] as other important preconditions in an intensification of business digitalization and organizational performance during business transformations [85].

Given the conception that the organizational management process is determined by the internal and external environments, we may suggest that the intensity and success of business digitalization depend on the interconnections between internal and external factors. External factors are strongly affected by spatial, spillover, and temporal effects on entrepreneurial activity [90]. Internal factors are strongly connected to individual characteristics of entrepreneurs (managers and founders), the mission and objectives of a company, and the operational process within a business model (including value creation, revenue policies, customer relations, etc.) [92]. These interconnections also provide evidence for the effects of digitalization on businesses through the interconnection of entrepreneurs’ characteristics (see the Entrepreneur dimension) and ecosystem processes (see the Ecosystem dimension). The capability for digital model transformation is often supported by digital infrastructure [69]. Social media and big-data technologies are especially considered the main forces for change for a business model framework through the generation of relevant information for the business [67]. Strategic learning helps transform the information into strategic knowledge and provides companies with the capability to adapt to changes or develop a market-entry strategy [69]. These critical insights into entrepreneurial knowledge and, consequently, the assessment of business risks, vulnerabilities, and opportunities are facilitated by digital platforms [73] that provide a field for the interaction of multiple actors [77]. This interaction may include resource and module networks for start-up and scale-up success and access to financial and human resources and venture investors [81,111]. This can be especially critical in the case of early-stage start-ups, which are based on a business model innovation in order to remain competitive within a dynamic environment. Scholars consider the Lean Startup Approach to be a method for the formation and evaluation of the appropriate business model since it allows entrepreneurs to test and refine their business hypotheses by redirecting production systems toward customer value [87,88,112,113]. Digital entrepreneurship also provides new value categories (i.e., functional, social, emotional, epistemic, conditional) and new value opportunities based on stakeholder interaction and new approaches for competing in digital ecosystems [96,106]. Several scholars claim that, in a business framework, digital solutions are strongly interrelated with value creation and revenue policies. In particular, as noted above, digital solutions may change the value chain by reducing some costs (e.g., reproduction, distribution, transaction costs) [95,97] or resource configurations [93] that may lead to the formation of sustainable business models [69,70]. These elements of business transformation in terms of digitalization also determine the development of digital entrepreneurship toward the formation of IT clusters (e.g., in India and the US) [91]. In regard to marketing activity, researchers also define several other affordances of digitalization. The advantages of a digital business model are correspondingly distinguished according to market entry (related to reduced entry costs, technological advantage as a competitive point, and/or digital services for setting the entry barriers) or resource availability [58,83]; the evaluation of decision-making efficiency; the optimization of strategies and processes for international market evaluation, particularly for lean global start-ups [89]; and the formation of communication ties and digital marketing tools [98].

The extended reflections based on the analysis of the initial nodes in the dimension of Entrepreneurial process allow us to distinguish four more determinants of digital entrepreneurship:

1. Prerequisites for digitalization: digital capabilities (e.g., digital potential, internal digital infrastructure maturity, digital ambition and digital fit); adoption of digital drivers; and digital facilities (e.g., flexibility and generativity of digital platforms, social media and big data sources, information products); 2. Dynamic shifts in the transformation of business: digital features in operation activities (e.g., reprogrammability, recombinability, generativity, customer relations); merging of value creation (e.g., changing sources, new opportunities, shifts in value propositions); revenue mechanism (e.g., revenue models); competition and leadership (e.g., market position, market strategy, pioneering strategies for start-ups, digital monopolies); knowledge acquisition and strategic learning (e.g., information-sharing capabilities, collaboration process capabilities); and digital business tendencies (e.g., digital business viability, digital business convergence, digital ethics);

3. Digital business model innovation: shifts in digital business model configurations (e.g., financial and investment, stakeholder interconnections and relations, operational/production processes, input/output strategies, resource configuration and orchestration); digital tools (e.g., digital artifacts, platforms, and infrastructure); risks associated with innovative business models (e.g., relational and performance risks); digital innovation models’ validation and assessment; and shortcomings in digital business models (e.g., task division, task allocation, reward distribution); and

4. Digital business affordances: intermediary role (e.g., connection between digital capacities and digital strategy development, interrelation between digital intensity and organizational performance, linkages between technical devices and marketing); enhancing role (e.g., support and development of competitive advantages, support in overcoming market barriers, support of market performance and market development, cost savings); and social influence (e.g., spillover effect).

# 6.3. Ecosystem

The categories that relate to the Ecosystem dimension are grouped into three initial nodes (see Table 1): processes within the ecosystem, facilitating conditions for digital entrepreneurship, and social networks [60,72,96,99,100,102–105,108,109].

Researchers claim that digital innovations go beyond company-level boundaries and require the formation of a digital ecosystem. Such an ecosystem becomes an accelerator for creating digital start-ups [101] and an environment that matches “digital artifacts” and digital users and agents, as well as providing digital governance, business management, and other affordances [107]. Particularly, the peculiarities of incubation processes within the ecosystem may affect the dynamics of digital entrepreneurship [103]. The broadest notion that describes the influence of the ecosystem is related to the context of digital entrepreneurship with different dimensions that enhance or constrain the development of such activity (e.g., temporal, historical, spatial, institutional, social, industry, organizational) [104]. As also stated previously, context dimensions affect the scale to which entrepreneurs may use digital competences [104] that, on the individual level, become the key determinants of the digital entrepreneurship ecosystem [101].

Given individual behavior, another influencing dimension is the online context that affects the broadening of social networks and, as a result, facilitates the acquisition of social capital through the development of structural connections between individuals, as well as the bridging of structural holes [105]. Such a network approach is directly interrelated with regional ICT access and entrepreneurship performance as it may become a facilitator in the conditions of resource constraints and institutional barriers [108]. This supports the proposition that digitalization helps to overcome institutional and sociocultural restrictions [60]. However, the ecosystem itself provides the supporting conditions for digital entrepreneurship. Particularly, several researchers claim the important role of cities as they provide possibilities for a sharing economy that allows overcoming institutional barriers and accomplishing institutional changes [109]. As well, business incubation facilities provide information assistance to new ventures [102], and Living Labs are tools for understanding the digital-entrepreneurship process from the idea creation stage to the start-up and business-management stage [100]. Digitalization also enhances the transformation in stakeholder interaction patterns and, consequently, new approaches for competing in digital ecosystems [96,106].

The analysis of the initial nodes and the understanding of the interactions between the relevant categories allow us to define three determinants of digital entrepreneurship within the Ecosystem dimension:

1. Regional digital business environment: resource availability/constraints (including regional ICT   
access); digital entrepreneurship attitudes (e.g., perception and resistance); and context effect on digital   
start-up formation (e.g., spatial and temporal influence, social, political, institutional, and legislative factors); 2. Digital business infrastructure: digital cluster framework (e.g., absorptive capacity, benefits for   
members, economic performance, influential factors, mobilizability capacity); facilitating conditions   
within the infrastructure (e.g., support of innovations by the digital ecosystem, incubation facilities,

information technology assistance); and digital infrastructure architecture (e.g., heterogeneity of digital infrastructure, digital infrastructure governance, information flows); and

3. Collaboration and social values: system of relationships (e.g., interconnections between agents, contact points, channels of partner relations, agents and users roles, knowledge orchestration and distribution) and community and network patterns (e.g., activity within the network, actor ties, resource and module networks, acquisition of social capital, structural holes effect).

Table 2 provides a summarized overview of the defined determinants of digital entrepreneurship.

Table 2. Determinants of digital entrepreneurship.   

<html><body><table><tr><td>Dimensions</td><td>Determinants</td></tr><tr><td></td><td>Determinant 1: Personal characteristics and competences</td></tr><tr><td></td><td>》Basic characteristics for starting a digital business 》Professional flexibility</td></tr><tr><td></td><td></td></tr><tr><td>Entrepreneur</td><td>Determinant 2: Decision-making and bounded rationality</td></tr><tr><td></td><td>》Opportunity-risk attitude</td></tr><tr><td></td><td>》Personal motivation</td></tr><tr><td></td><td>Determinant 3: Personal outcomes</td></tr><tr><td></td><td>》Social positioning</td></tr><tr><td></td><td>》Access to new entrepreneurial possibilities</td></tr><tr><td></td><td>Determinant 4: Prerequisites for digitalization</td></tr><tr><td></td><td>Digital capabilities</td></tr><tr><td></td><td>Adoption of digital drivers</td></tr><tr><td></td><td>Digital facilities</td></tr><tr><td></td><td>Determinant 5: Dynamic shifts in the transformation of business</td></tr><tr><td></td><td>Digital features in operation activities</td></tr><tr><td></td><td>Merging of value creation</td></tr><tr><td></td><td>Revenue mechanism</td></tr><tr><td></td><td>Competition and leadership</td></tr><tr><td>Entrepreneurial Process</td><td> Knowledge acquisition and strategic learning</td></tr><tr><td></td><td>Digital business tendencies</td></tr><tr><td></td><td>Determinant 6: Digital business model innovation</td></tr><tr><td>V</td><td>Shifts in digital business model configurations</td></tr><tr><td></td><td>Digital tools</td></tr><tr><td></td><td>Risks associated with innovative business models</td></tr><tr><td></td><td>Digital innovation models&#x27; validation and assessment</td></tr><tr><td></td><td>Shortcomings in digital business models</td></tr><tr><td></td><td></td></tr><tr><td></td><td>Determinant 7: Digital business affordances</td></tr><tr><td></td><td>》Intermediary role</td></tr><tr><td></td><td>V Enhancing role Socialinfluence</td></tr></table></body></html>

Table 2. Cont.   

<html><body><table><tr><td>Dimensions</td><td>Determinants</td></tr><tr><td colspan="2">Determinant 8: Regional digital business environment</td></tr><tr><td></td><td>Resource availability/constraints</td></tr><tr><td>V</td><td>Digital entrepreneurship attitudes</td></tr><tr><td></td><td>&gt; Context effect on digital start-up formation</td></tr><tr><td colspan="2">Determinant 9: Digital business infrastructure</td></tr><tr><td></td><td>Digital cluster framework</td></tr><tr><td></td><td> Facilitating conditions within the infrastructure</td></tr><tr><td></td><td>Digital infrastructure architecture</td></tr><tr><td colspan="2">Determinant 10: Collaboration and social values</td></tr><tr><td></td><td>》System of relationships</td></tr><tr><td></td><td> Community and network patterns</td></tr></table></body></html>

# 7. Future Research Directions for Sustainable Implications

The systematic literature review and its core findings relate primarily to the consolidation of existing research in the field of digital entrepreneurship as part of the innovation system. The results (see the section titled Discussion of the Results) provide evidence that digital transformation in existing businesses and entrepreneurship, in particular, exerts influence throughout the entire innovation system. Entrepreneurial activities are important drivers in the innovation system, and they directly affect the whole socioeconomic system. The results build the basis for a conceptual framework and the understanding of how changes of entrepreneurial structures under the effect of digital technologies influence the transformation of the innovation system as well as the socioeconomic system in general. Accordingly, the core direction provides avenues not only for content- and theory-related extensions but also for further application of PRISMA in analyzing the impact of digital transformation.

# 7.1. Method-Related Avenue: Extended Application of PRISMA in the Field of Socio-digital Transformations

As described earlier (see the section titled Approach to the Review: PRISMA Method), PRISMA was initially developed for research in a clinical field. Nevertheless, the method is applicable to other scientific disciplines based on the core idea of sequential analysis according to the determined research questions. A variety of different approaches exists for systematic literature reviews [114–116] as well as other methods (e.g., SQUIRE, CONSORT) [117,118]. In addition, some research relies on specific elements of the PRISMA approach (see e.g., [119,120]). However, the PRISMA method applied according to the defined statement may be beneficial due to the following advantages: (1) the clear statement of research questions (required by the PRISMA Checklist), (2) structured and transparent reporting (according to the PRISMA Flowchart), and (3) a clear definition of inclusion and exclusion criteria (required by the PRISMA Checklist).

# 7.2. Content-Related Avenue: Analysis of Vulnerabilities for Specific Socioeconomic Systems Brought about by Digitalization; Empirical Research of the Impact of Digitalization on the Sustainability of Socioeconomic Systems of Different Countries

The extended application of the PRISMA method may be particularly beneficial for understanding potential vulnerabilities related to digitalization. Current theoretical and applied research (including management studies) considers opportunities, as well as potential risks, related to digitalization for different dimensions of the socioeconomic system [6,7,121]. In addition, extended research on digital vulnerabilities may contribute to an understanding of the interdependencies between the socioeconomic system and global challenges in light of societal transitions. Such content-related issues also require extended empirical research [19,110,122,123]. Here, the integrated indices (e.g., Digital Evolution Index, International Digital Economy and Society Index, Network Readiness Index, European Index of Digital Entrepreneurship Systems, Ease of Doing Digital Business) are of particular importance and cover a broad range of different environmental conditions for digitalization or digital entrepreneurship activities (e.g., transaction infrastructure, citizen use of the internet, political and regulatory environment). Moreover, existing indices do not focus on the dimensions of mentality and behavioral aspects.

7.3. Theory-Related Avenue: Extension of Transdisciplinary as well as System-science Approaches in Management

The understanding of digital vulnerabilities within social transitions determines the importance of digital-vulnerability management as part of resilience management [6]. This is particularly important for the development of systems-thinking competences [50,51] for dealing with societal transition processes and challenges. Such approaches may be beneficial for both management research and entrepreneurial management, in particular, as well as resilience studies [124]. This is particularly true since social transformations determine the interconnection of entrepreneurial dimensions not only in regard to economic but also noneconomic issues (e.g., ecological, social responsibility). These interdependencies require systems-thinking competencies throughout the entire process of business management [125]. In addition, a requirement for systems thinking is for it to provide evidence of the importance of theoretical and applied research in the field of applied transdisciplinary approaches in management science and, particularly, resilience management [126,127].

# 8. Conclusions

The overarching goal of this research was to understand how current digital tendencies transform entrepreneurial and business frameworks and how these transformations are implemented in the innovation system. The comprehensive systematic literature review, which was conducted based on a PRISMA framework, allowed us to extract the core categories, form the initial nodes of digital entrepreneurship, and analyze their interactions as well as interconnections with other elements of the innovation system. In particular, these nodes helped to identify the determinants of digital entrepreneurship in three dimensions (i.e., entrepreneur, entrepreneurial process, and ecosystem), which cover a broad scope of elements from mentality patterns, personal characteristics, and outcomes to the organizational management process, and the influence of external infrastructure and institutions. The analysis helped us to identify the peculiarities of digital entrepreneurship in relation to traditional business mechanisms.

The results call for further research in three specific directions: (1) empirical research on the impact of digitalization on the socioeconomic system; (2) an analysis of vulnerabilities in specific socioeconomic systems brought about by digitalization; and (3) an extension of transdisciplinary and system science approaches in management. Extended, consistent research may contribute to the overall understanding of the transformation processes that take place in modern socioeconomic systems and define their interconnectedness with global challenges and problems. An additional implication includes the understanding of how the resilience and sustainability of the socioeconomic system and its interrelated dimensions may be affected by disturbances and vulnerability factors resulting from social transformations. With respect to innovation systems, the results presented in this paper suggest the application of a systems science approach in order to understand how the particular dimensions of the innovation system are interrelated. This includes the capture of potential vulnerabilities related to entrepreneurs and stakeholders and the understanding of how the resilience and sustainability of the innovation system may be influenced by internal as well as external disturbances. In an attempt to gain deeper knowledge of digital entrepreneurship as part of the innovation system, a comparative study approach across not only geographic but also functional boundaries might also be useful. Beyond the organizational context, policy implications regarding the establishment of a supporting ecosystem are crucial.

Author Contributions: Conceptualization, L.S. and G.S.; methodology, L.S. and G.S.; validation, L.S.; formal analysis, L.S.; investigation, L.S.; writing—original draft preparation, L.S.; writing—review and editing, L.S. and G.S.; visualization, L.S.; supervision, G.S. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Conflicts of Interest: The authors declare no conflict of interest.

# Appendix A

The Digital Economy and Society Index (DESI) provides trend analysis and comparisons of the digital performance of the EU 28 Member States within six different dimensions: Connectivity (the deployment of broadband infrastructure and its quality); Human Capital/Digital skills (the skills needed to take advantage of the possibilities offered by a digital society); Use of Internet Services by citizens (the variety of activities performed by citizens already online); Integration of Digital Technology by businesses (the digitization of businesses and development of the online sales channel); Digital Public Services (the digitization of public services, focusing on eGovernment); Research and Development ICT (trends of ICT Sector and R&D provided by the European Commission) (see https: //ec.europa.eu/digital-single-market/en/desi)

The International Digital Economy and Society Index (I-DESI) extends the EU28 Digital Economy and Society Index and provides trend analysis and comparisons of the digital performance of 45 countries (EU 28 Member States and 17 non-EU countries). I-DESI combines 24 indicators in five different dimensions and uses a weighting system to rank each country based on its digital performance. Distinguished dimensions: Connectivity; Digital skills; Citizen use of Internet; Business technology integration; Digital public services [123].

The European Index of Digital Entrepreneurship Systems (EIDES) measures physical and digital ecosystem conditions for stand-up, start-up, and scale-up ventures in 28 EU countries. EIDES encompasses four pillars for the General Framework Conditions (i.e., Culture and Informal Institutions; Formal Institutions, Regulation, and Taxation; Market Conditions; and Physical Infrastructure) and four pillars of the Systemic Framework Conditions (i.e., Human Capital; Knowledge Creation and Dissemination; Finance; and Networking and Support). In the EIDES theoretical structure, the General Framework Conditions apply broadly to entrepreneurship, while the Systemic Framework Conditions act differently across three stages of entrepreneurial development: stand-up, start-up, and scale-up [19].

# Appendix B

Table A1. Map of the study’s basic characteristics.   

<html><body><table><tr><td rowspan="2">Authors</td><td colspan="11">Countries of Affiliation and Research</td></tr><tr><td>AustraliaCameroon</td><td>Canada</td><td>RCzechicChile China</td><td></td><td>DenmarkFinlandFranceGermanySouth Korea</td><td>IndiaIranIreland</td><td>ItalyNetherlands Poland</td><td>Portugal Russia</td><td>ArudiaSpain Sweden</td><td>SwitzerlandUAEUKUSA</td><td></td></tr><tr><td>Alam,K. et al. Bouwman,H.etal. Dy，A.Met al.</td><td>√</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>√</td></tr><tr><td>Geissinger, A. et.al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td></tr><tr><td>CGhezz,A,hezz A,</td><td>A.</td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Gupta, G., Bose, I. Heavin,C.,Power,</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>D.J. Jabtonski,M.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Kotarba,M. Le Dinh,T.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Liu, J.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Loonam,J.etal. McAdam,.etl.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Nadeem,A.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Neubert,M.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Ngoasong,M.Z. Nissen,V.etl</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td></tr><tr><td>Nwaiwu,F.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Philip,L.,Wiliams,.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>√</td></tr><tr><td>Qian,H.,Zhao,C. Rojers,PJ.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Subramaniam,M. et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Suseno,Y.etal. Vendrell-Herro,.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Zahee,H.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Zhu, Z., Lin,S. Amit,R.,Han, X.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Dellermann,D.etal.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Farani,A.Y et al.</td><td></td><td></td><td></td><td></td><td></td><td>√</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Li,F.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Li,W. et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Nambisan,S. Nwankpa,J.,Dat,</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>P.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Pagani,M.,Pardo,C. Quinton,S.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Rao,P.,</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Balasubrahmanya, M.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Remane,G.et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Schallmo,D. et al.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Seo,D.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Sprenger,M.etal.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Srinivasan,A.,</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Venkatraman,N. Sussan,F.,s,ZJ</td><td>Zhang,F,Li,D.</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr></table></body></html>

Table A1. Cont.

![](images/1f68b5474d54b58f67337ab31573312ea2d6073d0fc1ade197a4a971180f5d30.jpg)

# Appendix C

Table A2. List of journals included in the systematic literature review (as of 20 March 2019).   

<html><body><table><tr><td> Journal</td><td>ISSN</td><td>H Index</td><td>Impact Factor</td><td>CiteScore</td><td>Number of Articles</td></tr><tr><td>Academy of Management Proceedings</td><td>2151-6561</td><td></td><td>0.10</td><td></td><td>1</td></tr><tr><td> Applied Geography</td><td>01436228</td><td>77</td><td>3.117</td><td>3.75</td><td>1</td></tr><tr><td>Business Horizons</td><td>00076813</td><td>67</td><td>2.588</td><td>2.96</td><td>1</td></tr><tr><td>Computers in Human Behavior</td><td>07475632</td><td>137</td><td>3.536</td><td>4.57</td><td>2</td></tr><tr><td>Digital Policy, Regulation and Governance</td><td>23985038</td><td>26</td><td></td><td>1.02</td><td>1</td></tr><tr><td>Entrepreneurship Theory and Practice</td><td>10422587</td><td>121</td><td>5.321</td><td>2.46</td><td>1</td></tr><tr><td>European Jourmal of Information Systems</td><td>0960085X,14769344</td><td>96</td><td>3.197</td><td>4.23</td><td>1</td></tr><tr><td>European Journal of Training and Development</td><td>20469012</td><td>49</td><td>二</td><td>1.45</td><td>1</td></tr><tr><td>Foresight and STI Governance</td><td>23129972</td><td>11</td><td>1</td><td>1.23</td><td>1</td></tr><tr><td> Foundations of Management</td><td>23005661</td><td>4</td><td>二</td><td>0.28</td><td>1</td></tr><tr><td>Frontiers of Business Research in China</td><td>16737326, 16737431</td><td>9</td><td>二</td><td>0.20</td><td>1</td></tr><tr><td> Industrial Marketing Management</td><td>00198501</td><td>114</td><td>3.678</td><td>3.76</td><td>1</td></tr><tr><td> Information and Management</td><td>03787206</td><td>142</td><td>3.890</td><td>5.24</td><td>1</td></tr><tr><td>Information Systems Frontiers</td><td>15729419, 13873326</td><td>55</td><td>3.232</td><td>3.63</td><td>1</td></tr><tr><td>International Journal of Entrepreneurship</td><td>10999264</td><td>9</td><td>二</td><td>0.24</td><td>1</td></tr><tr><td> International Journal of Innovation Management</td><td>13639196</td><td>34</td><td></td><td>0.97</td><td>1</td></tr><tr><td> Journal of Business Research</td><td>01482963</td><td>158</td><td>2.509</td><td>3.31</td><td>1</td></tr><tr><td>Journal of BusinessStrategy</td><td>02756668</td><td>34</td><td>二</td><td>0.63</td><td>2</td></tr><tr><td>Journal of Business Venturing</td><td>08839026</td><td>154</td><td>6.000</td><td>8.82</td><td>1</td></tr><tr><td> Journal of Competitiveness</td><td>1804-171X</td><td></td><td>二</td><td></td><td>1</td></tr><tr><td> Journal of Decision Systems</td><td>21167052,12460125</td><td>19</td><td></td><td>1.0</td><td>1</td></tr><tr><td> Journal of Rural Studies</td><td>07430167</td><td>88</td><td>2.658</td><td>3.14</td><td>2</td></tr><tr><td> Journal of Small Business and Enterprise Development</td><td>14626004</td><td>55</td><td>二</td><td>1.41</td><td>2</td></tr><tr><td> Journal of Strategic Information Systems</td><td>09638687</td><td>76</td><td>4.313</td><td>3.82</td><td>2</td></tr></table></body></html>

Table A2. Cont.   

<html><body><table><tr><td>Journal</td><td>ISSN</td><td>H Index</td><td>Impact Factor</td><td>CiteScore</td><td>Number of Articles</td></tr><tr><td>Journal of Strategic Marketing</td><td>0965254X,14664488</td><td>42</td><td>1</td><td>1.37</td><td>2</td></tr><tr><td> Journal of the Association for Information Systems</td><td>15369323</td><td>65</td><td>2.839</td><td>4.14</td><td>1</td></tr><tr><td>Journal of Theoretical and Applied Electronic Commerce Research</td><td>07181876</td><td>25</td><td>0.774</td><td>1</td><td>1</td></tr><tr><td>International Journal of Networking and Virtual Organisations</td><td>14709503,17415225</td><td>17</td><td>1</td><td>0.37</td><td>1</td></tr><tr><td>Organization Qualitative Market Research: An International Journal</td><td>13505084</td><td>88</td><td>2.701</td><td>1.69</td><td>1</td></tr><tr><td></td><td>13522752</td><td>46</td><td>1</td><td>0.88</td><td>1</td></tr><tr><td>Small Business Economics</td><td>15730913,0921898X</td><td>108</td><td>2.857</td><td></td><td>1</td></tr><tr><td>Strategic Change Strategic Entrepreneurship Journal</td><td>10991697</td><td>8</td><td>二</td><td>0.66</td><td>2</td></tr><tr><td>Sustainability</td><td>19324391, 1932443X</td><td>31</td><td>3.488</td><td>1</td><td>2</td></tr><tr><td>Technological Forecasting and Social Change</td><td>20711050</td><td>53</td><td>2.075</td><td>1</td><td>1</td></tr><tr><td></td><td>00401625</td><td>93</td><td>3.131</td><td>3.42</td><td>4</td></tr><tr><td>Technology Innovation Management Review</td><td>1927-0321</td><td></td><td>1</td><td>1</td><td>1</td></tr><tr><td>Technovation Telecommunications Policy</td><td>01664972</td><td>111</td><td>4.802</td><td>4.57</td><td>1</td></tr><tr><td></td><td>03085961</td><td>60</td><td>2.087</td><td>2.14</td><td>2</td></tr><tr><td>The International Technology Management Review</td><td>2213-7149</td><td></td><td>二</td><td>二</td><td>1</td></tr><tr><td>Transnational Corporations Review</td><td>1918-6444</td><td></td><td>1</td><td>1</td><td>1</td></tr></table></body></html>

# References

g ventures’ business models. Technol. Forecast. Soc. Chang. 2019, 146, 844–852. [CrossRef]   
2. Parviainen, P.; Kääriäinen, J.; Tihinen, M.; Teppola, S. Tackling the digitalization challenge: How to benefit from digitalization in practice. Int. J. Inf. Syst. Proj. Manag. 2017, 5, 63–77. [CrossRef]   
3. Stolterman, E.; Fors, A.C. Information Systems Research: Relevant Theory and Informed Practice. In Information Technology and the Good Life; Kluwer Academic Publishers: London, UK, 2004.   
4. Stolterman, E.; Fors, A.C. Information Technology and the Good Life. In Information Systems Research; Kaplan, B., Truex, D.P., Wastell, D., Wood-Harper, A.T., DeGross, J.I., Eds.; Kluwer Academic Publishers: Boston, MA, USA, 2004; Volume 143, pp. 687–692.   
5. Autio, E.; Nambisan, S.; Thomas, L.D.W.; Wright, M. Digital affordances, spatial affordances, and the genesis of entrepreneurial ecosystems. Strat. Entrep. J. 2018, 12, 72–95. [CrossRef]   
6. Scholz, R. Digital Threat and Vulnerability Management: The SVIDT Method. Sustainability 2017, 9, 554. [CrossRef]   
7. Scholz, R.W.; Czichos, R.; Parycek, P.; Lampoltshammer, T.J. Organizational vulnerability of digital threats: A first validation of an assessment method. Eur. J. Oper. Res. 2020, 282, 627–643. [CrossRef]   
8. Martín-Peña, M.L.; Diaz-Garrido, E.; Sánchez-López, J.M. The digitalization and servitization of manufacturing: A review on digital business models. Strat. Chang. 2018, 27, 91–99. [CrossRef]   
9. Nambisan, S.; Lyytinen, K.; Majchrzak, A.; Song, M. Digital Innovation Management: Reinventing Innovation Management Research in a Digital World. MIS Q. 2017, 41, 223–236. [CrossRef]   
10. Yu, C.; Zhang, Z.; Liu, Y. Understanding new ventures’ business model design in the digital era: An empirical study in China. Comput. Hum. Behav. 2019, 95, 238–251. [CrossRef]   
11. European Commission. Digital Transformation of European Industry and Enterprises; A report of the Strategic Policy Forum on Digital Entrepreneurship; 2015. Available online: https://ec.europa.eu/growth/content/ report-digital-transformation-european-industry-and-enterprises- $0 \_ \mathrm { e n }$ (accessed on 31 March 2020).   
12. Pagani, M. Digital Business Strategy and Value Creation: Framing the Dynamic Cycle of Control Points. MIS Q. 2013, 37, 617–632. [CrossRef]   
13. Vendrell-Herrero, F.; Bustinza, O.F.; Parry, G.; Georgantzis, N.; Georgantzis, N. Servitization, digitization and supply chain interdependency. Ind. Mark. Manag. 2017, 60, 69–81. [CrossRef]   
14. Ardolino, M.; Rapaccini, M.; Saccani, N.; Gaiardelli, P.; Crespi, G.; Ruggeri, C. The role of digital technologies for the service transformation of industrial companies. Int. J. Prod. Res. 2018, 56, 2116–2132. [CrossRef]   
15. Hinings, B.; Gegenhuber, T.; Greenwood, R. Digital innovation and transformation: An institutional perspective. Inf. Organ. 2018, 28, 52–61. [CrossRef]   
16. European Commission. Digital Entrepreneurship. The EU Vision, Strategy and Actions. Digital Europe NTA Summit; European Commission: Brussels, Belgium, 2014.   
17. Dong, J.Q. Moving a mountain with a teaspoon: Toward a theory of digital entrepreneurship in the regulatory environment. Technol. Forecast. Soc. Chang. 2019, 146, 923–930. [CrossRef]   
18. Rachinger, M.; Rauter, R.; Müller, C.; Vorraber, W.; Schirgi, E. Digitalization and its influence on business model innovation. J. Manuf. Technol. Manag. 2019, 30, 1143–1160. [CrossRef]   
19. Autio, E.; Szerb, L.; Komlósi, É.; Tiszberger, M. The European Index of Digital Entrepreneurship Systems; Publications Office of the European Union: Luxembourg, 2018. Available online: https://ec.europa.eu/jrc/en/ publication/european-index-digital-entrepreneurship-systems (accessed on 31 March 2020).   
20. Edquist, C. Systems of Innovation Technologies, Institutions and Organizations; Routledge Taylor & Francis Group: London, UK; New York, NY, USA, 2005.   
21. Freeman, C. Continental, national and sub-national innovation systems—Complementarity and economic growth. Res. Policy 2002, 31, 191–211. [CrossRef]   
22. Lundvall, B.-Å.; Johnson, B.; Andersen, E.; Dalum, B. National systems of production, innovation and competence building. Res. Policy 2002, 31, 213–231. [CrossRef]   
23. Nelson, R.; Rosenberg, N. Technical innovation and national systems. In National Innovation Systems: A Comparative Analysis; Oxford University: Oxford, UK, 1993.   
24. Schumpeter, J.A. The Theory of Economic Development. An Inquiry into Profits, Capital, Credit, Interest, and the Business Cycle; Harvard University Press: Cambridge, MA, USA, 1934.   
25. Lundvall, B.-A. National systems of innovation: Toward a theory of innovation and interactive learning; Anthem Press: London, UK, 2010.   
26. Lundvall, B.-Å. Product Innovation and User-Producer Interaction; Aalborg University Press: Aalborg, Denmark, 1985.   
27. Steiner, G. Supporting sustainable innovation through stakeholder management: A systems view. Int. J. Innov. Learn. 2008, 5, 595–616. [CrossRef]   
28. Steiner, G. Unlock Hidden Innovation Potentials: Uncertainty, Risk, & Opportunity Costs. In Proceedings of the IFA: Production and International Trade Conference, Paris, France, 22–24 February 2017.   
29. Steiner, G. From probabilistic functionalism to a mental simulation of innovation: By collaboration from vulnerabilities to resilient societal systems: Comment on “Managing complexity: From visual perception to sustainable transitions–contributions of Brunswik’s Theory of Probabilistic Functionalism”. Environ. Syst. Decis. 2018, 38, 92–98.   
30. Steiner, G. Competences for Complex Real-World Problems: Toward an Integrative Framework; Harvard University: Cambridge, MA, USA, 2013.   
31. Katz, J.S. What Is a Complex Innovation System? PLoS ONE 2016, 11, e0156150. [CrossRef]   
32. Scholz, R.W. Environmental Literacy in Science and Society by Roland W. Scholz; Cambridge University Press (CUP): Cambridge, NY, USA, 2011.   
33. Gunderson, L.H.; Holling, C.S. Panarchy: Understanding Transformations in Human and Natural Systems; Island Press: Washington, DC, USA, 2002.   
34. Christensen, M. The Innovator’s Dilemma: When New Technologies Cause Great Firms to Fail; Harvard Business Review Press: Boston, MA, USA, 2016.   
35. De Haan, J.H.; Rotmans, J. Patterns in transitions: Understanding complex chains of change. Technol. Forecast. Soc. Chang. 2011, 78, 90–102. [CrossRef]   
36. Geels, F.W. Technological transitions as evolutionary reconfiguration processes: A multi-level perspective and a case-study. Res. Policy 2002, 31, 1257–1274. [CrossRef]   
37. Geels, F.W. Ontologies, socio-technical transitions (to sustainability), and the multi-level perspective. Res. Policy 2010, 39, 495–510. [CrossRef]   
38. Geels, F.W.; Schot, J. Typology of sociotechnical transition pathways. Res. Policy 2007, 36, 399–417. [CrossRef]   
39. Kemp, R.; Loorbach, D.; Rotmans, J. Transition management as a model for managing processes of co-evolution towards sustainable development. Int. J. Sustain. Dev. World Ecol. 2007, 14, 78–91. [CrossRef]   
40. Nill, J.; Kemp, R. Evolutionary approaches for sustainable innovation policies: From niche to paradigm? Res. Policy 2009, 38, 668–680. [CrossRef]   
41. Rotmans, J.; Loorbach, D. Complexity and Transition Management. J. Ind. Ecol. 2009, 13, 184–196. [CrossRef]   
42. Schumpeter, J.A. Capitalism, Socialism and Democracy, 1st ed.; Harper & Brothers Publishers: Manhattan, NK, USA, 1942.   
43. Fritsch, M. The theory of economic development—An inquiry into profits, capital, credit, interest, and the business cycle. Reg. Stud. 2017, 51, 654–655. [CrossRef]   
44. Juma, C. Complexity, Innovation, and Development: Schumpeter Revisited. Policy Complex Syst. 2014, 1, 4–21.   
45. Porter, M.E.; Stern, S. The New Challenge to America’s Prosperity: Findings from the Innovation Index; Council on Competitiveness: Washington, DC, USA, 1999.   
46. Sledzik, K. Schumpeter ´ ´s View on Innovation and Entrepreneurship. In Management Trends in Theory and Practice; University of Zilina & Institute of Management by University of Zilina: Žilina, Slovakia, 2013.   
47. Dosi, G.; Pavitt, K.; Soete, L. The Economics of Technical Change and International Trade; Harvester Wheatsheaf: London, UK, 1990.   
48. Nelson, R.R. The Role of Firm differences in An evolutionary Theory of technical Advance. In Evolutionary and Neo-Schumpeterian Approaches to Economics; Magnusson, L., Ed.; Springer: Dordrecht, The Netherlands, 1994; Volume 36, pp. 231–242.   
49. Nelson, R.R.; Winter, S.G. An Evolutionary Theory of Economic Change, Digitally Reprinted; The Belknap Press of Harvard Univ. Press: Cambridge, MA, USA, 1982.   
50. Steiner, G.; Risopoulos, F.; Mulej, M. Competences for Citizen-Driven Innovation in Crisis Resolution. Syst. Pract. Action Res. 2013, 26, 571–577. [CrossRef]   
51. Steiner, G.; Risopoulos, F.; Mulej, M. Social Responsibility and Citizen-Driven Innovation in Sustainably Mastering Global Socio-Economic Crises. Syst. Res. Behav. Sci. 2015, 32, 160–167. [CrossRef]   
52. Liberati, A.; Altman, U.G.; Tetzlaff, J.; Mulrow, C.; Gøtzsche, P.C.; Ioannidis, J.P.; Clarke, M.; Devereaux, P.J.; Kleijnen, J.; Moher, D. The PRISMA statement for reporting systematic reviews and meta-analyses of studies that evaluate health care interventions: Explanation and elaboration. J. Clin. Epidemiol. 2009, 62, e1–e34. [CrossRef] [PubMed]   
53. Moher, D.; Cook, D.J.; Eastwood, S.; Olkin, I.; Rennie, U.; Stroup, D.F. Improving the quality of reports of meta-analyses of randomised controlled trials: The QUOROM statement. Lancet 1999, 354, 1896–1900. [CrossRef]   
54. Vieira, L.C.; Serrao-Neumann, S.; Howes, M.; Mackey, B. Unpacking components of sustainable and resilient urban food systems. J. Clean. Prod. 2018, 200, 318–330. [CrossRef]   
55. Van Laar, E.; Van Deursen, A.J.; Van Dijk, J.A.; De Haan, J. The relation between 21st-century skills and digital skills: A systematic literature review. Comput. Hum. Behav. 2017, 72, 577–588. [CrossRef]   
56. Moher, D.; Liberati, A.; Tetzlaff, J.; Altman, D.G. Preferred reporting items for systematic reviews and meta-analyses: The PRISMA statement. Int. J. Surg. 2010, 8, 336–341. [CrossRef]   
57. Liberati, A.; Altman, U.G.; Tetzlaff, J.; Mulrow, C.; Gøtzsche, P.C.; Ioannidis, J.P.A.; Clarke, M.; Devereaux, P.J.; Kleijnen, J.; Moher, D. The PRISMA Statement for Reporting Systematic Reviews and Meta-Analyses of Studies That Evaluate Health Care Interventions: Explanation and Elaboration. PLoS Med 2009, 6, e1000100. [CrossRef]   
58. Anwar, M.N.; Daniel, E. Entrepreneurial marketing in online businesses. Qual. Mark. Res. Int. J. 2016, 19, 310–338. [CrossRef]   
59. Martinez Dy, A.; Martin, L.; Marlow, S. Emancipation through digital entrepreneurship? A critical realist analysis. Organization 2018, 25, 585–608. [CrossRef]   
60. McAdam, M.; Crowley, C.; Harrison, R.J. “To boldly go where no [man] has gone before”—Institutional voids and the development of women’s digital entrepreneurship. Technol. Forecast. Soc. Chang. 2018, 146, 912–922. [CrossRef]   
61. Philip, L.J.; Williams, F. Remote rural home based businesses and digital inequalities: Understanding needs and expectations in a digitally underserved community. J. Rural. Stud. 2018, 68, 306–318. [CrossRef]   
62. Dutot, V.; Van Horne, C. Digital Entrepreneurship Intention in a Developed vs. Emerging Country: An Exploratory Study in France and the UAE. Transnatl. Corp. Rev. 2015, 7, 79–96. [CrossRef]   
63. Farani, A.Y.; Karimi, S.; Motaghed, M. The role of entrepreneurial knowledge as a competence in shaping Iranian students’ career intentions to start a new digital business. Eur. J. Train. Dev. 2017, 41, 83–100. [CrossRef]   
64. Heavin, C.; Power, D.J. Challenges for digital transformation – towards a conceptual decision support guide for managers. J. Decis. Syst. 2018, 27, 38–45. [CrossRef]   
65. Zhu, Z.; Lin, S.-F. Understanding entrepreneurial perceptions in the pursuit of emerging e-business opportunities: The dimensions and drivers. Comput. Hum. Behav. 2018. [CrossRef]   
66. Liu, J.; Nandhakumar, J.; Zachariadis, M. When guanxi meets structural holes: Exploring the guanxi networks of Chinese entrepreneurs on digital platforms. J. Strat. Inf. Syst. 2018, 27, 311–334. [CrossRef]   
67. Bouwman, H.; Nikou, S.; Molina-Castillo, F.-J.; De Reuver, M. The impact of digitalization on business models. Digit. Policy, Regul. Gov. 2018, 20, 105–124. [CrossRef]   
68. Dellermann, D.; Fliaster, A.; Kolloch, M. Innovation risk in digital business models: The German energy sector. J. Bus. Strat. 2017, 38, 35–43. [CrossRef]   
69. Gupta, G.; Bose, I. Strategic learning for digital market pioneering: Examining the transformation of Wishberry’s crowdfunding model. Technol. Forecast. Soc. Chang. 2018, 146, 865–876. [CrossRef]   
70. Jablonski, M. Value Migration to the Sustainable Business Models of Digital Economy Companies on the Capital Market. Sustainability 2018, 10, 3113. [CrossRef]   
71. Kotarba, M. Digital Transformation of Business Models. Found. Manag. 2018, 10, 123–142. [CrossRef]   
72. Li, F. The digital transformation of business models in the creative industries: A holistic framework and emerging trends. Technovation 2017, in press. [CrossRef]   
73. Nambisan, S. Digital Entrepreneurship: Toward a Digital Technology Perspective of Entrepreneurship. Entrep. Theory Pract. 2017, 41, 1029–1055. [CrossRef]   
74. Nwaiwu, F. Tomas Bata University in Zlín Review and Comparison of Conceptual Frameworks on Digital Business Transformation. J. Compet. 2018, 10, 86–100.   
75. Nwankpa, J.K.; Datta, P. Balancing exploration and exploitation of IT resources: The influence of Digital Business Intensity on perceived organizational performance. Eur. J. Inf. Syst. 2017, 26, 469–488. [CrossRef]   
76. Pagani, M.; Pardo, C. The impact of digital technology on relationships in a business network. Ind. Mark. Manag. 2017, 67, 185–192. [CrossRef]   
77. Remane, G.; Hanelt, A.; Nickerson, R.C.; Kolbe, L.M. Discovering digital business models in traditional industries. J. Bus. Strat. 2017, 38, 41–51. [CrossRef]   
78. Schallmo, D.; Williams, C.A.; Boardman, L. Digital transformation of business models—Best practice, enablers, and roadmap. Int. J. Innov. Manag. 2017, 21. [CrossRef]   
79. Seo, D. Chungbuk National University Digital Business Convergence and Emerging Contested Fields: A Conceptual Framework. J. Assoc. Inf. Syst. 2017, 18, 687–702.   
80. Sprenger, M.; Mettler, T.; Winter, R. Erratum to: A viability theory for digital businesses: Exploring the evolutionary changes of revenue mechanisms to support managerial decisions. Inf. Syst. Front. 2017, 19, 899–922. [CrossRef]   
81. Srinivasan, A.; Venkatraman, N. Entrepreneurship in digital platforms: A network-centric view. Strat. Entrep. J. 2017, 12, 54–71. [CrossRef]   
82. Standing, C.; Mattsson, J. “Fake it until you make it”: Business model conceptualization in digital entrepreneurship. J. Strat. Mark. 2016. [CrossRef]   
83. Vendrell-Herrero, F.; Parry, G.; Bustinza, O.F.; Gomes, E. Digital business models: Taxonomy and future research avenues. Strat. Chang. 2018, 27, 87–90. [CrossRef]   
84. Loonam, J.; Eaves, S.; Kumar, V.; Parry, G. Towards digital transformation: Lessons learned from traditional organizations. Strat. Chang. 2018, 27, 101–109. [CrossRef]   
85. Nisse, V.; Ilmenau University of Technology; Lezina, T.; Saltan, A. St. Petersburg State University The Role of IT-Management in the Digital Transformation of Russian Companies. Foresight STI Gov. 2018, 12, 53–61. [CrossRef]   
86. Quinton, S.; Canhoto, A.; Molinillo, S.; Pera, R.; Budhathoki, T. Conceptualising a digital orientation: Antecedents of supporting SME performance in the digital economy. J. Strat. Mark. 2017, 26, 427–439. [CrossRef]   
87. Ghezzi, A. Digital startups and the adoption and implementation of Lean Startup Approaches: Effectuation, Bricolage and Opportunity Creation in practice. Technol. Forecast. Soc. Chang. 2018, 146, 945–960. [CrossRef]   
88. Ghezzi, A.; Cavallo, A. Agile Business Model Innovation in Digital Entrepreneurship: Lean Startup Approaches. J. Bus. Res. 2018. [CrossRef]   
89. Neubert, M. The Impact of Digitalization on the Speed of Internationalization of Lean Global Startups. Technol. Innov. Manag. Rev. 2018, 8, 44–54. [CrossRef]   
90. Qian, H.; Zhao, C. Space-time analysis of high technology entrepreneurship: A comparison of California and New England. Appl. Geogr. 2018, 95, 111–119. [CrossRef]   
91. Rao, P.; Balasubrahmanya, M. The rise of IT services clusters in India: A case of growth by replication. Telecommun. Policy 2017, 41, 90–105. [CrossRef]   
92. Zaheer, H.; Breyer, Y.; Dumay, J.; Enjeti, M. Straight from the horse’s mouth: Founders’ perspectives on achieving ‘traction’ in digital start-ups. Comput. Hum. Behav. 2018. [CrossRef]   
93. Amit, R.; Han, X. Value Creation through Novel Resource Configurations in a Digitally Enabled World. Strat. Entrep. J. 2017, 11, 228–242. [CrossRef]   
94. Nadeem, A.; Abedin, B.; Cerpa, N.; Chew, E. Editorial: Digital Transformation & Digital Business Strategy in Electronic Commerce—The Role of Organizational Capabilities. J. Theor. Appl. Electron. Commer. Res. 2018, 13, I–VIII. [CrossRef]   
95. Rojers, J.P. Digital Transformation, Business Model Innovation and Efficiency in Content Industries: A Review. Int. Technol. Manag. Rev. 2018, 7, 59–70. [CrossRef]   
96. Suseno, Y.; Laurell, C.; Sick, N. Assessing value creation in digital innovation ecosystems: A Social Media Analytics approach. J. Strat. Inf. Syst. 2018. [CrossRef]   
97. Zhao, J.; Chi, M.; Zhu, Z.; Hu, L. From digital business strategy to e-business value creation: A three-stage process model. Int. J. Netw. Virtual Organ. 2015, 15, 215–241. [CrossRef] 2015, 22, 633–651. [CrossRef]   
99. Alam, K.; Erdiaw-Kwasie, M.O.; Shahiduzzaman, M.; Ryan, B. Assessing regional digital competence: Digital futures and strategic planning implications. J. Rural. Stud. 2018, 60, 60–69. [CrossRef]   
100. Le Dinh, T.; Vu, M.C.; Ayayi, A. Towards a Living Lab for promoting the digital entrepreneurship process. Int. J. Entrep. 2018, 22. Available online: https://www.abacademies.org/abstract/towards-a-living-lab-forpromoting-the-digital-entrepreneurship-process-7036.html (accessed on 31 March 2020).   
101. Li, W.; Du, W.; Yin, J. Digital entrepreneurship ecosystem as a new form of organizing: The case of Zhongguancun. Front. Bus. Res. China 2017, 11. [CrossRef]   
102. Mack, E.A.; Marie-Pierre, L.; Redican, K. Entrepreneurs’ use of internet and social media applications. Telecommun. Policy 2016, 41, 120–139. [CrossRef]   
103. Mankevich, V.; Holmström, J. Gateways to Digital Entrepreneurship: Investigating the Organizing Logics for Digital Startups. Acad. Manag. Proc. 2016, 2016. [CrossRef]   
104. Ngoasong, M. Digital entrepreneurship in a resource-scarce context. J. Small Bus. Enterp. Dev. 2018, 25, 483–500. [CrossRef]   
105. Smith, C.; Smith, J.B.; Shaw, E. Embracing digital networks: Entrepreneurs’ social capital online. J. Bus. Ventur. 2016, 32, 18–34. [CrossRef]   
106. Subramaniam, M.; Iyer, B.; Venkatraman, V. Competing in digital ecosystems. Bus. Horizons 2018, 62, 83–94. [CrossRef]   
107. Sussan, F.; Acs, Z.J. The digital entrepreneurial ecosystem. Small Bus. Econ. 2017, 49, 1–19. [CrossRef]   
108. Zhang, F.; Li, D. Regional ICT access and entrepreneurship: Evidence from China. Inf. Manag. 2017. [CrossRef]   
109. Geissinger, A.; Laurell, C.; Sandström, C.; Eriksson, K.; Nykvist, R. Digital entrepreneurship and field conditions for institutional change—Investigating the enabling role of cities. Technol. Forecast. Soc. Chang. 2019, 146, 877–886. [CrossRef]   
110. Chakravorti, B.; Bhalla, A.; Chaturvedi, R.S. Digital Planet 2017. How Competitiveness and Trust in Digital Economies Vary Across the World; The Fletcher School, Tufts University: Medford, MA, USA, 2017.   
111. Cavallo, A.; Ghezzi, A.; Dell’Era, C.; Pellizzoni, E. Fostering digital entrepreneurship from startup to scaleup: The role of venture capital funds and angel groups. Technol. Forecast. Soc. Chang. 2019, 145, 24–35. [CrossRef]   
112. Shepherd, D.A.; Gruber, M. The Lean Startup Framework: Closing the Academic–Practitioner Divide. Entrep. Theory Pract. 2020, 104225871989941. [CrossRef]   
113. Balocco, R.; Cavallo, A.; Ghezzi, A.; Berbegal-Mirabent, J. Lean business models change process in digital entrepreneurship. Bus. Process. Manag. J. 2019, 25, 1520–1542. [CrossRef]   
114. Bocconcelli, R.; Cioppi, M.; Fortezza, F.; Francioni, B.; Pagano, A.; Savelli, E.; Splendiani, S. SMEs and Marketing: A Systematic Literature Review: SMEs and Marketing. Int. J. Manag. Rev. 2018, 20, 227–254. [CrossRef]   
115. Nolan, C.T.; Garavan, T.N. Human Resource Development in SMEs: A Systematic Review of the Literature. Int. J. Manag. Rev. 2016, 18, 85–107. [CrossRef]   
116. Sweeney, A.; Clarke, N.; Higgs, M. Shared Leadership in Commercial Organizations: A Systematic Review of Definitions, Theoretical Frameworks and Organizational Outcomes. Int. J. Manag. Rev. 2019, 21, 115–136. [CrossRef]   
117. Goodman, D.; Ogrinc, G.; Davies, L.; Baker, G.R.; Barnsteiner, J.; Foster, T.C.; Gali, K.; Hilden, J.; Horwitz, L.; Kaplan, H.C.; et al. Explanation and elaboration of the SQUIRE (Standards for Quality Improvement Reporting Excellence) Guidelines, V.2.0: Examples of SQUIRE elements in the healthcare improvement literature. BMJ Qual. Saf. 2016, 25, e7. [CrossRef] [PubMed]   
118. Turner, L.; Shamseer, L.; Altman, D.G.; Schulz, K.F.; Moher, D. Does use of the CONSORT Statement impact the completeness of reporting of randomised controlled trials published in medical journals? A Cochrane reviewa. Syst. Rev. 2012, 1. [CrossRef]   
119. Bailey, C.; Madden, A.; Alfes, K.; Fletcher, L. The Meaning, Antecedents and Outcomes of Employee Engagement: A Narrative Synthesis: Employee Engagement. Int. J. Manag. Rev. 2015, 19, 31–53. [CrossRef]   
120. Kranzbühler, A.-M.; Kleijnen, M.H.; Morgan, R.E.; Teerling, M. The Multilevel Nature of Customer Experience Research: An Integrative Review and Research Agenda. Int. J. Manag. Rev. 2018, 20, 433–456. [CrossRef]   
121. Scholz, R. Sustainable Digital Environments: What Major Challenges Is Humankind Facing? Sustain. 2016, 8, 726. [CrossRef]   
122. Chakravorti, B.; Fillpovic, C.; Chaturvedi, R.S. Ease of Doing Digital Business 2019. Which Countries Help Expedite Entry, Growth, and Exit of Technology-Based Businesses? The Fletcher School, Tufts University, Medford 2019. Available online: https://sites.tufts.edu/digitalplanet/research/ease-of-doing-digital-business/ (accessed on 31 March 2020).   
123. Paul, F.; Lawrence, G.; Jake, M.; David, S.; Ian, W. European Commission, Content and Technology Directorate General for Communications Networks, and Tech4i2. 2018. International Digital Economy and Society Index 2018: Final Report. Available online: http://publications.europa.eu/publication/manifestation_identifier/ PUB_KK0118476ENN (accessed on 31 March 2020).   
124. Linnenluecke, M.K. Resilience in Business and Management Research: A Review of Influential Publications and a Research Agenda. Int. J. Manag. Rev. 2017, 19, 4–30. [CrossRef]   
125. Rebernik, M.; Hojnik, B.B.; Tominc, P.; Sirec, K.; Crnogaj, K.; Rus, M.; Knez-Riedl, J.; Mocnik, D.; Ksenja, P.; Tadej, K.; et al. Building an Entrepreneurial Society 25 Years of Entrepreneurship at FEB UM; University of Maribor Press: Maribor, Slovenia, 2018.   
126. Scholz, R.; Steiner, G. The real type and ideal type of transdisciplinary processes: Part I—Theoretical foundations. Sustain. Sci. 2015, 10, 527–544. [CrossRef]   
127. Scholz, R.; Steiner, G. The real type and ideal type of transdisciplinary processes: Part II—What constraints and obstacles do we meet in practice? Sustain. Sci. 2015, 10, 653–671. [CrossRef]